/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public abstract class AbstractWaitWithProgressJob<T> {
    private final int attempts;
    private final long sleepTime;
    private final boolean shouldRetryOnError;

    public AbstractWaitWithProgressJob(int attempts, long sleepTime) {
        this.attempts = attempts;
        this.sleepTime = sleepTime;
        this.shouldRetryOnError = false;
    }

    public AbstractWaitWithProgressJob(int attempts, long sleepTime, boolean shouldRetryOnError) {
        this.attempts = attempts;
        this.sleepTime = sleepTime;
        this.shouldRetryOnError = shouldRetryOnError;
    }

    protected abstract T runInWait(IProgressMonitor var1) throws CoreException;

    protected boolean shouldRetryOnError(Throwable t) {
        return this.shouldRetryOnError;
    }

    protected boolean isValid(T result) {
        return result != null;
    }

    public T run(IProgressMonitor monitor) throws CoreException {
        Throwable lastError = null;
        T result = null;
        int i = 0;
        while (i < this.attempts) {
            if (monitor != null && monitor.isCanceled()) break;
            boolean reattempt = false;
            try {
                result = this.runInWait(monitor);
                reattempt = !this.isValid(result);
            }
            catch (Throwable th) {
                lastError = th;
                reattempt = this.shouldRetryOnError(lastError);
            }
            if (!reattempt) break;
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        if (!this.isValid(result) && lastError != null) {
            CoreException coreError = lastError instanceof CoreException ? (CoreException)lastError : CloudErrorUtil.toCoreException(lastError);
            throw coreError;
        }
        return result;
    }
}

