/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.standalone.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cft.server.standalone.core.internal.application.StandaloneFacetHandler;
import org.eclipse.cft.server.standalone.ui.internal.Messages;
import org.eclipse.cft.server.ui.internal.actions.AbstractMenuContributionFactory;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.menus.IMenuService;

public class ProjectExplorerMenuFactory
extends AbstractMenuContributionFactory {
    public ProjectExplorerMenuFactory() {
        super("popup:org.eclipse.ui.projectConfigure?endof=additions", null);
    }

    protected List<IAction> getActions(IMenuService menuService) {
        IEvaluationContext context = menuService.getCurrentState();
        IProject project = this.getProjectFromContext(context);
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (project != null) {
            StandaloneFacetHandler handler = new StandaloneFacetHandler(project);
            if (handler.canAddFacet()) {
                actions.add((IAction)new ConvertToStandaloneAction(project));
            } else if (handler.hasFacet()) {
                actions.add((IAction)new RemoveStandaloneAction(project));
            }
        }
        return actions;
    }

    protected IProject getProjectFromContext(Object context) {
        IProject project = null;
        if (context instanceof IEvaluationContext) {
            List content;
            Object evalContext = ((IEvaluationContext)context).getDefaultVariable();
            if (evalContext instanceof List && !(content = (List)evalContext).isEmpty()) {
                evalContext = content.get(0);
            }
            if (evalContext instanceof IProject) {
                project = (IProject)evalContext;
            } else if (evalContext instanceof IAdaptable) {
                project = (IProject)((IAdaptable)evalContext).getAdapter(IProject.class);
            }
        }
        return project;
    }

    public class ConvertToStandaloneAction
    extends Action {
        protected final IProject project;

        public ConvertToStandaloneAction(IProject project) {
            this.project = project;
            this.setActionValues();
        }

        protected void setActionValues() {
            this.setText(Messages.ProjectExplorerMenuFactory_LABEL_CONVERT_TEXT);
            this.setToolTipText(Messages.ProjectExplorerMenuFactory_LABEL_CONVERT_TOOLTIP);
            this.setEnabled(true);
        }

        public void run() {
            Job job = new Job(Messages.ProjectExplorerMenuFactory_JOB_ENABLE){

                protected IStatus run(IProgressMonitor monitor) {
                    new StandaloneFacetHandler(ConvertToStandaloneAction.this.project).addFacet(monitor);
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(false);
            job.schedule();
        }
    }

    public class RemoveStandaloneAction
    extends Action {
        protected final IProject project;

        public RemoveStandaloneAction(IProject project) {
            this.project = project;
            this.setActionValues();
        }

        protected void setActionValues() {
            this.setText(Messages.ProjectExplorerMenuFactory_LABEL_REMOVE_TEXT);
            this.setToolTipText(Messages.ProjectExplorerMenuFactory_LABEL_REMOVE_TOOLTIP);
            this.setEnabled(true);
        }

        public void run() {
            Job job = new Job(Messages.ProjectExplorerMenuFactory_JOB_DISABLE){

                protected IStatus run(IProgressMonitor monitor) {
                    new StandaloneFacetHandler(RemoveStandaloneAction.this.project).removeFacet();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(false);
            job.schedule();
        }
    }
}

