/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.verify.ui.internal;

import org.eclipse.cft.server.verify.ui.internal.Activator;
import org.eclipse.cft.server.verify.ui.internal.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IStartup;

public class JREVersionVerifier
implements IStartup {
    private static Shell parent = null;

    public void earlyStartup() {
        final String verStr = System.getProperty("java.version");
        if (verStr != null) {
            final String curVersionStr = Activator.getDefault().getBundle().getVersion().toString();
            String lastVersionStr = Activator.getDefault().getLastPluginJavaVersionCheck();
            boolean isLastVersionMatch = lastVersionStr.equals(curVersionStr);
            if (verStr.compareTo("1.7") < 0) {
                if (!isLastVersionMatch || Activator.getDefault().getIsCheckJavaVersion()) {
                    Display.getDefault().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            MessageDialog.openError((Shell)JREVersionVerifier.getParent(), (String)Messages.CloudFoundryEclipseToolsErrorTitle, (String)NLS.bind((String)Messages.UnsupportedJavaVersion, (Object)verStr));
                            Activator.getDefault().setIsCheckJavaVersion(false);
                            Activator.getDefault().setLastPluginJavaVersionCheck(curVersionStr);
                        }
                    });
                }
            } else if (!Activator.getDefault().getIsCheckJavaVersion()) {
                Activator.getDefault().setIsCheckJavaVersion(true);
            }
        }
    }

    private static Shell getActiveWorkbenchShell() {
        Shell shell = null;
        try {
            shell = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        catch (Exception exception) {}
        return shell == null ? JREVersionVerifier.getCurrentDisplay().getActiveShell() : shell;
    }

    private static Display getCurrentDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private static Shell getFocusShell() {
        Shell focusShell = null;
        try {
            focusShell = JREVersionVerifier.getActiveWorkbenchShell();
        }
        catch (Exception exception) {}
        return focusShell;
    }

    private static Shell getParent() {
        if (parent == null) {
            parent = JREVersionVerifier.getFocusShell();
        }
        return parent;
    }
}

