/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.ui.internal.wizards;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.cloudfoundry.client.lib.CloudFoundryException;
import org.eclipse.cft.server.core.AbstractCloudFoundryUrl;
import org.eclipse.cft.server.core.internal.CloudFoundryBrandingExtensionPoint;
import org.eclipse.cft.server.ui.internal.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class CloudUrlWizardPage
extends WizardPage {
    private String name;
    private String url;
    private boolean selfSigned;
    private Label messageLabel;
    boolean canFinish = false;
    private final List<AbstractCloudFoundryUrl> allCloudUrls;
    protected static final String TITLE = Messages.CloudUrlWizardPage_TITLE_CLOUD_URL;
    protected static final String DESCRIPTION = Messages.CloudUrlWizardPage_TEXT_DESCRIPT;

    protected CloudUrlWizardPage(List<CloudFoundryBrandingExtensionPoint.CloudServerURL> allCloudUrls, ImageDescriptor descriptor, String url, String name, boolean selfSigned) {
        super(Messages.CloudUrlWizardPage_TEXT_CLOUD_URL);
        if (allCloudUrls == null) {
            this.allCloudUrls = null;
        } else {
            this.allCloudUrls = new ArrayList<AbstractCloudFoundryUrl>();
            for (CloudFoundryBrandingExtensionPoint.CloudServerURL serverUrl : allCloudUrls) {
                this.allCloudUrls.add((AbstractCloudFoundryUrl)serverUrl);
            }
        }
        this.name = name;
        this.url = url;
        this.selfSigned = selfSigned;
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        if (descriptor != null) {
            this.setImageDescriptor(descriptor);
        }
    }

    protected CloudUrlWizardPage(ImageDescriptor descriptor, String url, String name, boolean selfSigned, List<AbstractCloudFoundryUrl> allCloudUrls) {
        super(Messages.CloudUrlWizardPage_TEXT_CLOUD_URL);
        this.allCloudUrls = allCloudUrls;
        this.name = name;
        this.url = url;
        this.selfSigned = selfSigned;
        this.setTitle(TITLE);
        this.setDescription(DESCRIPTION);
        if (descriptor != null) {
            this.setImageDescriptor(descriptor);
        }
    }

    public void createControl(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).hint(400, -1).applyTo((Control)area);
        GridLayoutFactory.fillDefaults().margins(10, 10).numColumns(1).applyTo(area);
        Composite composite = new Composite(area, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.messageLabel = new Label(composite, 0);
        this.messageLabel.setText(Messages.CloudUrlWizardPage_LABEL_CLOUD_URL_NAME);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.messageLabel);
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(Messages.COMMONTXT_NAME_WITH_COLON);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)nameLabel);
        final Text nameText = new Text(composite, 2048);
        nameText.setEditable(true);
        if (this.name != null) {
            nameText.setText(this.name);
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)nameText);
        nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CloudUrlWizardPage.this.name = nameText.getText();
                CloudUrlWizardPage.this.update();
            }
        });
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(Messages.COMMONTXT_URL);
        GridDataFactory.fillDefaults().align(4, 0x1000000).applyTo((Control)urlLabel);
        final Text urlText = new Text(composite, 2048);
        urlText.setEditable(true);
        if (this.url != null) {
            urlText.setText(this.url);
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)urlText);
        urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CloudUrlWizardPage.this.url = urlText.getText();
                if (CloudUrlWizardPage.this.url != null) {
                    CloudUrlWizardPage.this.url = CloudUrlWizardPage.this.url.trim();
                }
                CloudUrlWizardPage.this.update();
            }
        });
        Composite buttonArea = new Composite(area, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonArea);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(buttonArea);
        final Button selfSignedButton = new Button(buttonArea, 32);
        selfSignedButton.setText(Messages.CloudUrlWizardPage_SELF_SIGNED);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)selfSignedButton);
        selfSignedButton.setSelection(this.selfSigned);
        selfSignedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CloudUrlWizardPage.this.selfSigned = selfSignedButton.getSelection();
            }
        });
        Dialog.applyDialogFont((Control)composite);
        this.setControl((Control)composite);
        if (this.name != null || this.url != null) {
            this.update();
        }
    }

    private void update() {
        if (this.name == null || this.name.length() == 0) {
            this.messageLabel.setText(Messages.CloudUrlWizardPage_LABEL_A_CLOUD_URL);
            this.canFinish = false;
        } else if (this.url == null || this.url.length() == 0) {
            this.messageLabel.setText(Messages.CloudUrlWizardPage_LABEL_ENTER_CLOUD_URL);
            this.canFinish = false;
        } else {
            this.canFinish = true;
            for (AbstractCloudFoundryUrl cloudUrl : this.allCloudUrls) {
                if (cloudUrl.getUrl().contains("{") || !cloudUrl.getName().equals(this.name)) continue;
                this.canFinish = false;
                this.messageLabel.setText(NLS.bind((String)Messages.CloudUrlWizardPage_LABEL_SET_DIFF_URL, (Object)this.name));
            }
            if (this.canFinish) {
                try {
                    URL urlObject = new URL(this.url);
                    String host = urlObject.getHost();
                    if (host == null || host.length() == 0) {
                        this.canFinish = false;
                        this.messageLabel.setText(Messages.COMMONTXT_ENTER_VALID_URL);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    this.messageLabel.setText(Messages.COMMONTXT_ENTER_VALID_URL);
                    this.canFinish = false;
                }
                catch (CloudFoundryException cloudFoundryException) {
                    this.messageLabel.setText(Messages.CloudUrlWizardPage_LABEL_INVALID_CONTROLLER);
                    this.canFinish = false;
                }
                if (this.canFinish) {
                    this.messageLabel.setText(Messages.CloudUrlWizardPage_LABEL_CREATE_NEW_URL);
                }
            }
        }
        if (this.canFinish) {
            this.setErrorMessage(null);
        } else {
            String messageText = this.messageLabel.getText();
            this.setErrorMessage(messageText != null && messageText.length() > 0 ? this.messageLabel.getText() : Messages.CloudUrlWizardPage_ERROR_INVALID_URL);
        }
        this.getWizard().getContainer().updateButtons();
        this.setPageComplete(this.canFinish);
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean getSelfSigned() {
        return this.selfSigned;
    }

    public boolean isPageComplete() {
        return this.canFinish;
    }
}

