/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.core.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;

public abstract class AbstractMetaModelAdapter
implements TraceMetaModelAdapter {
    private List<Connection> getInternalElementsTransitive(EObject element, EObject traceModel, List<Object> accumulator, List<String> selectedRelationshipTypes, int currentDepth, int maximumDepth, List<Connection> existingTraces) {
        List<Connection> directElements = this.getInternalElements(element, traceModel, selectedRelationshipTypes, true, maximumDepth, existingTraces);
        ArrayList<Connection> allElements = new ArrayList<Connection>();
        int currDepth = currentDepth + 1;
        for (Connection connection : directElements) {
            if (accumulator.contains(connection.getTlink())) continue;
            allElements.add(connection);
            accumulator.add(connection.getTlink());
            for (EObject e : connection.getTargets()) {
                if (maximumDepth != 0 && currDepth >= maximumDepth + 2) continue;
                allElements.addAll(this.getInternalElementsTransitive(e, traceModel, accumulator, selectedRelationshipTypes, currDepth, maximumDepth, existingTraces));
            }
        }
        return allElements;
    }

    @Override
    public List<Connection> getInternalElementsTransitive(EObject element, EObject traceModel, List<String> traceLinkTypes, int maximumDepth) {
        ArrayList<Object> accumulator = new ArrayList<Object>();
        ArrayList<Connection> existingTraces = new ArrayList<Connection>();
        return this.getInternalElementsTransitive(element, traceModel, accumulator, traceLinkTypes, 0, maximumDepth, existingTraces);
    }

    @Override
    public List<Connection> getInternalElements(EObject element, EObject traceModel, List<String> traceLinkTypes) {
        return this.getInternalElements(element, traceModel, traceLinkTypes, false, 0, new ArrayList<Connection>());
    }

    private List<Connection> getInternalElements(EObject element, EObject traceModel, List<String> traceLinkTypes, boolean traceLinksTransitive, int transitivityDepth, List<Connection> existingTraces) {
        Object originalObject;
        IArtifactHandler<?> handler;
        ArrayList<Connection> allElements = new ArrayList<Connection>();
        List<Connection> directElements = traceLinksTransitive ? this.getTransitivelyConnectedElements(element, traceModel, traceLinkTypes, transitivityDepth) : this.getConnectedElements(element, traceModel, traceLinkTypes);
        ArrayList<Integer> hashCodes = new ArrayList<Integer>();
        for (Connection conn : existingTraces) {
            hashCodes.add(conn.hashCode());
        }
        ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
        TracePersistenceAdapter persistenceAdapter = ExtensionPointHelper.getTracePersistenceAdapter().orElseThrow();
        EObject artifactModel = persistenceAdapter.getArtifactWrappers(resourceSet);
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        for (Connection conn : directElements) {
            if (!hashCodes.contains(conn.hashCode())) {
                allElements.add(conn);
            }
            for (EObject o : conn.getOrigins()) {
                Object origin = artifactHelper.unwrapWrapper(o);
                IArtifactHandler<?> originHandler = artifactHelper.getHandler(origin).get();
                if (originHandler == null) continue;
                allElements.addAll(originHandler.getInternalLinks(o, traceLinkTypes));
            }
            for (EObject o : conn.getTargets()) {
                Object originalObject2 = artifactHelper.unwrapWrapper(o);
                IArtifactHandler<?> handler2 = artifactHelper.getHandler(originalObject2).orElseThrow();
                if (handler2 == null) continue;
                allElements.addAll(handler2.getInternalLinks(o, traceLinkTypes));
            }
        }
        if (directElements.isEmpty() && (handler = artifactHelper.getHandler(originalObject = artifactHelper.unwrapWrapper(element)).orElseThrow()) != null) {
            allElements.addAll(handler.getInternalLinks(element, traceLinkTypes));
        }
        if (element.getClass().getPackage().toString().contains("org.eclipse.eatop")) {
            IArtifactHandler<?> handler3 = artifactHelper.getHandler(element).orElseThrow();
            allElements.addAll(handler3.getInternalLinks(element, traceLinkTypes));
        }
        return allElements;
    }

    @Override
    public boolean isThereAnInternalTraceBetween(EObject first, EObject second) {
        ResourceSet resourceSet = EditingDomainHelper.getResourceSet();
        TracePersistenceAdapter persistenceAdapter = ExtensionPointHelper.getTracePersistenceAdapter().orElseThrow();
        EObject artifactModel = persistenceAdapter.getArtifactWrappers(resourceSet);
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        IArtifactHandler<?> handlerFirstElement = artifactHelper.getHandler(first).orElseThrow();
        IArtifactHandler<?> handlerSecondElement = artifactHelper.getHandler(second).orElseThrow();
        return handlerFirstElement.isThereAnInternalTraceBetween(first, second) || handlerSecondElement.isThereAnInternalTraceBetween(first, second);
    }
}

