/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.core.adapters;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.TraceMetaModelAdapter;
import org.eclipse.capra.core.adapters.TracePersistenceAdapter;
import org.eclipse.capra.core.handlers.IArtifactHandler;
import org.eclipse.capra.core.helpers.ArtifactHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public abstract class AbstractMetaModelAdapter
implements TraceMetaModelAdapter {
    private List<Connection> getInternalElementsTransitive(EObject element, EObject traceModel, List<Object> accumulator, List<String> selectedRelationshipTypes, int currentDepth, int maximumDepth, List<Connection> existingTraces) {
        List<Connection> directElements = this.getInternalElements(element, traceModel, selectedRelationshipTypes, true, maximumDepth, existingTraces);
        ArrayList<Connection> allElements = new ArrayList<Connection>();
        int currDepth = currentDepth + 1;
        for (Connection connection : directElements) {
            if (accumulator.contains(connection.getTlink())) continue;
            allElements.add(connection);
            accumulator.add(connection.getTlink());
            for (EObject e : connection.getTargets()) {
                if (maximumDepth != 0 && currDepth >= maximumDepth + 2) continue;
                allElements.addAll(this.getInternalElementsTransitive(e, traceModel, accumulator, selectedRelationshipTypes, currDepth, maximumDepth, existingTraces));
            }
        }
        return allElements;
    }

    @Override
    public List<Connection> getInternalElementsTransitive(EObject element, EObject traceModel, List<String> selectedRelationshipTypes, int maximumDepth, List<Connection> existingTraces) {
        ArrayList<Object> accumulator = new ArrayList<Object>();
        return this.getInternalElementsTransitive(element, traceModel, accumulator, selectedRelationshipTypes, 0, maximumDepth, existingTraces);
    }

    @Override
    public List<Connection> getInternalElements(EObject element, EObject traceModel, List<String> selectedRelationshipTypes, boolean traceLinksTransitive, int transitivityDepth, List<Connection> existingTraces) {
        Object originalObject;
        IArtifactHandler<?> handler;
        ArrayList<Connection> allElements = new ArrayList<Connection>();
        List<Connection> directElements = traceLinksTransitive ? this.getTransitivelyConnectedElements(element, traceModel, selectedRelationshipTypes, transitivityDepth) : this.getConnectedElements(element, traceModel, selectedRelationshipTypes);
        ArrayList<Integer> hashCodes = new ArrayList<Integer>();
        for (Connection conn : existingTraces) {
            int connectionHash = conn.getOrigin().hashCode() + conn.getTlink().hashCode();
            for (EObject targ : conn.getTargets()) {
                connectionHash += targ.hashCode();
            }
            hashCodes.add(connectionHash);
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        TracePersistenceAdapter persistenceAdapter = ExtensionPointHelper.getTracePersistenceAdapter().get();
        EObject artifactModel = persistenceAdapter.getArtifactWrappers((ResourceSet)resourceSet);
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        for (Connection conn : directElements) {
            Object origin;
            IArtifactHandler<?> originHandler;
            int connectionHash = conn.getOrigin().hashCode() + conn.getTlink().hashCode();
            for (EObject targ : conn.getTargets()) {
                connectionHash += targ.hashCode();
            }
            if (!hashCodes.contains(connectionHash)) {
                allElements.add(conn);
            }
            if ((originHandler = artifactHelper.getHandler(origin = artifactHelper.unwrapWrapper(conn.getOrigin())).get()) != null) {
                allElements.addAll(originHandler.addInternalLinks(conn.getOrigin(), selectedRelationshipTypes));
            }
            for (EObject o : conn.getTargets()) {
                Object originalObject2 = artifactHelper.unwrapWrapper(o);
                IArtifactHandler<?> handler2 = artifactHelper.getHandler(originalObject2).get();
                if (handler2 == null) continue;
                allElements.addAll(handler2.addInternalLinks(o, selectedRelationshipTypes));
            }
        }
        if (directElements.size() == 0 && (handler = artifactHelper.getHandler(originalObject = artifactHelper.unwrapWrapper(element)).get()) != null) {
            allElements.addAll(handler.addInternalLinks(element, selectedRelationshipTypes));
        }
        if (element.getClass().getPackage().toString().contains("org.eclipse.eatop")) {
            IArtifactHandler handler3 = artifactHelper.getHandler(element).orElse(null);
            allElements.addAll(handler3.addInternalLinks(element, selectedRelationshipTypes));
        }
        return allElements;
    }

    @Override
    public boolean isThereAnInternalTraceBetween(EObject first, EObject second) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        TracePersistenceAdapter persistenceAdapter = ExtensionPointHelper.getTracePersistenceAdapter().get();
        EObject artifactModel = persistenceAdapter.getArtifactWrappers((ResourceSet)resourceSet);
        ArtifactHelper artifactHelper = new ArtifactHelper(artifactModel);
        IArtifactHandler handlerFirstElement = artifactHelper.getHandler(first).orElse(null);
        IArtifactHandler handlerSecondElement = artifactHelper.getHandler(second).orElse(null);
        return handlerFirstElement.isThereAnInternalTraceBetween(first, second) || handlerSecondElement.isThereAnInternalTraceBetween(first, second);
    }
}

