/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.launch;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.launch.GradleTestRunConfigurationAttributes;
import org.eclipse.buildship.core.internal.launch.RunGradleJvmTestLaunchRequestJob;
import org.eclipse.buildship.core.internal.util.variable.ExpressionUtils;
import org.eclipse.buildship.ui.internal.launch.EditorJavaElementResolver;
import org.eclipse.buildship.ui.internal.launch.JavaElementResolver;
import org.eclipse.buildship.ui.internal.launch.LaunchMessages;
import org.eclipse.buildship.ui.internal.launch.SelectionJavaElementResolver;
import org.eclipse.buildship.ui.internal.launch.TestLaunchShortcutValidator;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public final class TestLaunchShortcut
implements ILaunchShortcut {
    public void launch(ISelection selection, String mode) {
        SelectionJavaElementResolver resolver = SelectionJavaElementResolver.from(selection);
        this.launch(resolver, mode);
    }

    public void launch(IEditorPart editor, String mode) {
        EditorJavaElementResolver resolver = EditorJavaElementResolver.from(editor);
        this.launch(resolver, mode);
    }

    private void launch(JavaElementResolver resolver, String mode) {
        List<IMethod> methods;
        List<IType> types = resolver.resolveTypes();
        if (TestLaunchShortcutValidator.validateTypesAndMethods(types, methods = resolver.resolveMethods())) {
            IProject project = this.findProject(types, methods);
            GradleTestRunConfigurationAttributes attributes = TestLaunchShortcut.createLaunchConfigAttributes(project, resolver.resolveTests());
            ILaunchConfiguration launchConfiguration = CorePlugin.gradleLaunchConfigurationManager().getOrCreateTestRunConfiguration(attributes);
            new RunGradleJvmTestLaunchRequestJob(launchConfiguration, mode).schedule();
        } else {
            this.showNoTestsFoundDialog();
        }
    }

    private static GradleTestRunConfigurationAttributes createLaunchConfigAttributes(IProject project, List<String> tests) {
        return new GradleTestRunConfigurationAttributes(ExpressionUtils.encodeWorkspaceLocation((IProject)project), GradleDistribution.fromBuild().toString(), null, null, Collections.emptyList(), Collections.emptyList(), false, false, false, false, false, tests);
    }

    private IProject findProject(List<IType> types, List<IMethod> methods) {
        Iterator<IType> iterator = types.iterator();
        if (iterator.hasNext()) {
            IType t = iterator.next();
            return t.getJavaProject().getProject();
        }
        iterator = methods.iterator();
        if (iterator.hasNext()) {
            IMethod m = (IMethod)iterator.next();
            return m.getJavaProject().getProject();
        }
        throw new GradlePluginsRuntimeException("Empty selection should not be valid for test launch shortcut");
    }

    private void showNoTestsFoundDialog() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                MessageDialog.openWarning((Shell)shell, (String)LaunchMessages.Test_Not_Found_Dialog_Title, (String)String.format("%s%n%s", LaunchMessages.Test_Not_Found_Dialog_Message, LaunchMessages.Test_Not_Found_Dialog_Details));
            }
        });
    }
}

