/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.gen.ide;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.mwe.core.issues.MWEDiagnostic;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xtend.expression.ExceptionHandler;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.expression.Variable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowUIExceptionHandler
implements ExceptionHandler {
    boolean errorShown;
    List<MWEDiagnostic> exceptions = new ArrayList<MWEDiagnostic>();

    public void handleRuntimeException(RuntimeException ex, SyntaxElement element, ExecutionContext ctx, Map<String, Object> additionalContextInfo) {
        if (this.exceptions == null) {
            this.exceptions = new ArrayList<MWEDiagnostic>();
        }
        String msg = "An exception occurred while generating metaABM model. \n";
        msg = String.valueOf(msg) + "(Any further exceptions will be shown in log view.)";
        msg = String.valueOf(msg) + "Template: " + element.getFileName() + "\n";
        msg = String.valueOf(msg) + "Name: " + element.getNameString(ctx) + "\n";
        msg = String.valueOf(msg) + "Line: " + element.getLine() + "\n";
        msg = String.valueOf(msg) + "Start/End: " + element.getStart() + " - " + element.getEnd() + "\n";
        for (Variable var : ctx.getVisibleVariables().values()) {
            msg = String.valueOf(msg) + var.getName() + ": " + var.getValue() + "\n";
        }
        MWEDiagnostic issue = new MWEDiagnostic(0, msg, (Object)ex, msg, (Throwable)ex, null, null);
        this.exceptions.add(issue);
    }

    public MWEDiagnostic[] getExceptions() {
        return this.exceptions.toArray(new MWEDiagnostic[0]);
    }
}

