/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.axf.ide;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.amp.axf.core.AbstractLifecycleListener;
import org.eclipse.amp.axf.core.ILifeCycleListener;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.core.IObservationProvider;
import org.eclipse.amp.axf.ide.AXFWorkbenchPlugin;
import org.eclipse.amp.axf.ide.IModelWorkbenchListener;
import org.eclipse.amp.axf.ide.ModelViewManager;
import org.eclipse.amp.axf.ide.handlers.ModelRunHandler;
import org.eclipse.amp.axf.ide.view.RunMonitorView;
import org.eclipse.amp.axf.ide.view.StatusLineView;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ModelManagerViewPart
extends ViewPart {
    static final Image RUN_IMAGE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.amp.axf.ide", (String)"icons/etool16/run_exc.gif").createImage();
    static final Image PAUSE_IMAGE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.amp.axf.ide", (String)"icons/etool16/run_pause.gif").createImage();
    static final Image STOP_IMAGE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.amp.axf.ide", (String)"icons/etool16/run_stop.gif").createImage();
    static final Image CLOSE_IMAGE = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.amp.axf.ide", (String)"icons/etool16/run_close.gif").createImage();
    ILifeCycleListener genericListener = new GenericListener();
    private TreeViewer viewer;

    public synchronized void refreshViewer() {
        if (!this.viewer.getControl().isDisposed()) {
            this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ModelManagerViewPart.this.viewer.refresh(true);
                }
            });
        }
    }

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent);
        this.viewer.setContentProvider((IContentProvider)new ModelContents());
        this.assignManager();
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ModelManagerViewPart.this.refreshViewer();
            }
        });
    }

    private void assignManager() {
        new Thread(){

            public void run() {
                AXFWorkbenchPlugin axf = AXFWorkbenchPlugin.getDefault();
                while (axf == null) {
                    try {
                        3.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                    axf = AXFWorkbenchPlugin.getDefault();
                }
                final ModelViewManager manager = axf.getManager();
                ILabelProvider testLabelProvider = (ILabelProvider)Platform.getAdapterManager().getAdapter((Object)manager, ILabelProvider.class);
                while (testLabelProvider == null) {
                    testLabelProvider = (ILabelProvider)Platform.getAdapterManager().getAdapter((Object)manager, ILabelProvider.class);
                    try {
                        Thread.sleep(30L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                final ILabelProvider modelLabelProvider = (ILabelProvider)Platform.getAdapterManager().getAdapter((Object)manager, ILabelProvider.class);
                ModelManagerViewPart.this.viewer.getControl().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        ModelLabelProvider labelProvider = new ModelLabelProvider(modelLabelProvider);
                        ModelManagerViewPart.this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
                        ModelManagerViewPart.this.viewer.setInput((Object)manager);
                    }
                });
                manager.getManagerListeners().addModelManagerListener(new ManagerListener());
                ModelManagerViewPart.this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                        if (sel.getFirstElement() instanceof IModel) {
                            manager.setActiveModel((IModel)sel.getFirstElement());
                        }
                    }
                });
                ModelManagerViewPart.this.getSite().setSelectionProvider((ISelectionProvider)ModelManagerViewPart.this.viewer);
                manager.setManagerViewPart(ModelManagerViewPart.this);
            }
        }.start();
    }

    public void setFocus() {
    }

    private final class GenericListener
    extends AbstractLifecycleListener {
        private GenericListener() {
        }

        public void observationEnd(IObservationProvider observed) {
            ModelManagerViewPart.this.refreshViewer();
        }

        public void observationEnding(IObservationProvider observed) {
            ModelManagerViewPart.this.refreshViewer();
        }

        public void observeCreate(IObservationProvider observed) {
            ModelManagerViewPart.this.refreshViewer();
        }

        public void observeInitialize(IObservationProvider observed) {
            ModelManagerViewPart.this.refreshViewer();
        }

        public void observeStart(IObservationProvider observed) {
            ModelManagerViewPart.this.refreshViewer();
        }

        public void observeStop(IObservationProvider observed) {
            ModelManagerViewPart.this.refreshViewer();
        }
    }

    private class ManagerListener
    implements IModelWorkbenchListener {
        private ManagerListener() {
        }

        public void modelActivated(IModel model) {
            ModelManagerViewPart.this.refreshViewer();
        }

        public void modelAdded(IModel model) {
            model.addModelListener(ModelManagerViewPart.this.genericListener);
            ModelManagerViewPart.this.refreshViewer();
        }

        public void modelRemoved(IModel model) {
            model.removeModelListener(ModelManagerViewPart.this.genericListener);
            ModelManagerViewPart.this.refreshViewer();
        }

        public void viewActivated(IWorkbenchPart part) {
            ModelManagerViewPart.this.refreshViewer();
        }

        public void viewAdded(IWorkbenchPart part) {
            ModelManagerViewPart.this.refreshViewer();
        }

        public void viewRemoved(IWorkbenchPart part) {
            ModelManagerViewPart.this.refreshViewer();
        }
    }

    private class ModelContents
    implements ITreeContentProvider {
        private ModelContents() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IModel) {
                Collection modelListeners = ((IModel)parentElement).getModelListeners();
                ArrayList<ILifeCycleListener> userModelListeners = new ArrayList<ILifeCycleListener>();
                for (ILifeCycleListener listener : modelListeners) {
                    if (listener instanceof ModelRunHandler || listener instanceof StatusLineView || listener instanceof RunMonitorView || listener == ModelManagerViewPart.this.genericListener) continue;
                    userModelListeners.add(listener);
                }
                return userModelListeners.toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IModel && this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return ((ModelViewManager)inputElement).getModels().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private final class ModelLabelProvider
    extends LabelProvider
    implements IColorProvider {
        private final ILabelProvider modelLabelProvider;

        private ModelLabelProvider(ILabelProvider modelLabelProvider) {
            this.modelLabelProvider = modelLabelProvider;
        }

        public String getText(Object element) {
            String name;
            if (element instanceof AbstractLifecycleListener) {
                String name2 = ((AbstractLifecycleListener)element).getName();
                if (name2 == null) {
                    return element.getClass().getSimpleName();
                }
                return name2;
            }
            if (this.modelLabelProvider != null && (name = this.modelLabelProvider.getText(element)) != null) {
                return name;
            }
            if (element instanceof IModel) {
                return this.getText(((IModel)element).getRoot());
            }
            return super.getText(element);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof IModel) {
                ModelViewManager manager = AXFWorkbenchPlugin.getDefault().getManager();
                IModel model = (IModel)element;
                if (manager.getActiveModel() == model) {
                    return ModelManagerViewPart.this.getViewSite().getShell().getDisplay().getSystemColor(6);
                }
                if (model.getEngine().isPaused() || !model.getEngine().isRunning()) {
                    return ModelManagerViewPart.this.getViewSite().getShell().getDisplay().getSystemColor(18);
                }
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof IModel) {
                IModel model = (IModel)element;
                if (model.getEngine().isPaused()) {
                    return PAUSE_IMAGE;
                }
                if (model.getEngine().isRunning() || model.isActive()) {
                    return RUN_IMAGE;
                }
                if (model.getEngine().isCloseRequested()) {
                    return CLOSE_IMAGE;
                }
                if (model.isStopped() && model.isInitialized()) {
                    return STOP_IMAGE;
                }
            }
            return null;
        }
    }
}

