/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.testing.aTest;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Measure implements Enumerator
{
    COUNT(0, "COUNT", "Count"),
    AVERAGE(1, "AVERAGE", "Average"),
    SUM(2, "SUM", "Sum"),
    MINIMUM(3, "MINIMUM", "Minimum"),
    MAXIMUM(4, "MAXIMUM", "Maximum");

    public static final int COUNT_VALUE = 0;
    public static final int AVERAGE_VALUE = 1;
    public static final int SUM_VALUE = 2;
    public static final int MINIMUM_VALUE = 3;
    public static final int MAXIMUM_VALUE = 4;
    private static final Measure[] VALUES_ARRAY;
    public static final List<Measure> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Measure[]{COUNT, AVERAGE, SUM, MINIMUM, MAXIMUM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Measure get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Measure result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Measure getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Measure result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Measure get(int value) {
        switch (value) {
            case 0: {
                return COUNT;
            }
            case 1: {
                return AVERAGE;
            }
            case 2: {
                return SUM;
            }
            case 3: {
                return MINIMUM;
            }
            case 4: {
                return MAXIMUM;
            }
        }
        return null;
    }

    private Measure(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

