/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.ide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.metaabm.IID;
import org.metaabm.MetaABMPackage;
import org.metaabm.SAgent;
import org.metaabm.SAttribute;
import org.metaabm.act.AAll;
import org.metaabm.act.ABuild;
import org.metaabm.act.ABuildProjection;
import org.metaabm.act.ACommand;
import org.metaabm.act.ACreateAgents;
import org.metaabm.act.AEvaluate;
import org.metaabm.act.AGroup;
import org.metaabm.act.ALogic;
import org.metaabm.act.AQuery;
import org.metaabm.act.ASelect;
import org.metaabm.act.MetaABMActPackage;
import org.metaabm.ide.MetaABMEditor;
import org.metaabm.ide.MetaABMModelerPlugin;
import org.metaabm.ide.MetaModelerPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaABMEditorActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(MetaModelerPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                MetaABMEditorActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                MetaModelerPlugin.INSTANCE.log((Object)exception);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(MetaModelerPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return MetaABMEditorActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (MetaABMEditorActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)MetaABMEditorActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected IAction assignDefaultValuesAction = new Action("Assign Default Values"){

        public boolean isEnabled() {
            ISelection selection;
            if (MetaABMEditorActionBarContributor.this.selectionProvider != null && (selection = MetaABMEditorActionBarContributor.this.selectionProvider.getSelection()) instanceof IStructuredSelection) {
                List l = ((IStructuredSelection)selection).toList();
                for (Object object : l) {
                    if (!(object instanceof SAttribute)) continue;
                    return true;
                }
            }
            return false;
        }

        public void run() {
            InputDialog d = new InputDialog(null, "Assign Default", "Value to apply to selected attributes:", "0.0", null);
            d.open();
            String value = d.getValue();
            ISelection selection = MetaABMEditorActionBarContributor.this.selectionProvider.getSelection();
            if (selection instanceof IStructuredSelection) {
                List l = ((IStructuredSelection)selection).toList();
                CompoundCommand cmd = new CompoundCommand();
                EditingDomain domain = ((MetaABMEditor)MetaABMEditorActionBarContributor.this.activeEditorPart).getEditingDomain();
                for (Object object : l) {
                    if (!(object instanceof SAttribute)) continue;
                    cmd.append(SetCommand.create((EditingDomain)domain, object, (Object)MetaABMPackage.Literals.SATTRIBUTE__DEFAULT_VALUE, (Object)value));
                }
                domain.getCommandStack().execute((Command)cmd);
            }
        }
    };
    protected IAction toggleStatsAction = new Action("Toggle Gather Data"){

        public boolean isEnabled() {
            ISelection selection;
            if (MetaABMEditorActionBarContributor.this.selectionProvider != null && (selection = MetaABMEditorActionBarContributor.this.selectionProvider.getSelection()) instanceof IStructuredSelection) {
                List l = ((IStructuredSelection)selection).toList();
                for (Object object : l) {
                    if (!(object instanceof SAttribute)) continue;
                    return true;
                }
            }
            return false;
        }

        public void run() {
            ISelection selection = MetaABMEditorActionBarContributor.this.selectionProvider.getSelection();
            if (selection instanceof IStructuredSelection) {
                List l = ((IStructuredSelection)selection).toList();
                CompoundCommand cmd = new CompoundCommand();
                EditingDomain domain = ((MetaABMEditor)MetaABMEditorActionBarContributor.this.activeEditorPart).getEditingDomain();
                for (Object object : l) {
                    if (!(object instanceof SAttribute)) continue;
                    cmd.append(SetCommand.create((EditingDomain)domain, object, (Object)MetaABMPackage.Literals.SATTRIBUTE__GATHER_DATA, (Object)(!((SAttribute)object).isGatherData() ? 1 : 0)));
                }
                domain.getCommandStack().execute((Command)cmd);
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected Collection<IAction> createSelectTargetActions;
    protected Collection<IAction> createCommandTargetActions;
    protected Collection<IAction> createBuildTargetActions;
    protected Collection<IAction> createOtherTargetActions;
    protected IMenuManager createChildMenuManager;
    private MenuManager createSelectTargetMenuManager;
    private MenuManager createCommandTargetMenuManager;
    private MenuManager createBuildTargetMenuManager;
    protected IMenuManager createOtherTargetMenuManager;
    protected Collection<IAction> otherActions;
    private IMenuManager submenuManager;
    private IMenuManager createTargetMenuManager;

    public MetaABMEditorActionBarContributor() {
        super(1);
        this.loadResourceAction = new LoadResourceAction();
        this.validateAction = new ValidateAction();
        this.controlAction = new ControlAction();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("metaabm-settings"));
        toolBarManager.add((IContributionItem)new Separator("metaabm-additions"));
    }

    public void contributeToMenu(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        this.submenuManager = new MenuManager(MetaABMModelerPlugin.INSTANCE.getString("_UI_MetaABMEditor_menu"), "org.metaabmMenuID");
        menuManager.insertAfter("additions", (IContributionItem)this.submenuManager);
        this.submenuManager.add((IContributionItem)new Separator("settings"));
        this.submenuManager.add((IContributionItem)new Separator("actions"));
        this.submenuManager.add((IContributionItem)new Separator("additions"));
        this.submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createTargetMenuManager = new MenuManager(MetaABMModelerPlugin.INSTANCE.getString("_UI_CreateTarget_menu"), null);
        this.submenuManager.insertBefore("additions", (IContributionItem)this.createTargetMenuManager);
        this.createTargetMenuManager.add((IContributionItem)new Separator("additions"));
        this.createSelectTargetMenuManager = new MenuManager(MetaABMModelerPlugin.INSTANCE.getString("_UI_CreateSelect_menu_item"));
        this.createTargetMenuManager.insertBefore("additions", (IContributionItem)this.createSelectTargetMenuManager);
        this.createBuildTargetMenuManager = new MenuManager(MetaABMModelerPlugin.INSTANCE.getString("_UI_CreateBuild_menu_item"));
        this.createTargetMenuManager.insertBefore("additions", (IContributionItem)this.createBuildTargetMenuManager);
        this.createCommandTargetMenuManager = new MenuManager(MetaABMModelerPlugin.INSTANCE.getString("_UI_CreateCommand_menu_item"));
        this.createTargetMenuManager.insertBefore("additions", (IContributionItem)this.createCommandTargetMenuManager);
        this.createOtherTargetMenuManager = new MenuManager(MetaABMModelerPlugin.INSTANCE.getString("_UI_CreateOther_menu_item"));
        this.createTargetMenuManager.insertBefore("additions", (IContributionItem)this.createOtherTargetMenuManager);
        this.createChildMenuManager = new MenuManager(MetaABMModelerPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        this.submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions(this.submenuManager);
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createOtherTargetMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSelectTargetMenuManager, this.createChildActions);
            this.depopulateManager((IContributionManager)this.createCommandTargetMenuManager, this.createChildActions);
            this.depopulateManager((IContributionManager)this.createBuildTargetMenuManager, this.createChildActions);
            this.depopulateManager((IContributionManager)this.createOtherTargetMenuManager, this.createChildActions);
        }
        Collection newChildDescriptors = new ArrayList();
        ArrayList<CommandParameter> selectTargetDescriptors = new ArrayList<CommandParameter>();
        ArrayList<CommandParameter> commandTargetDescriptors = new ArrayList<CommandParameter>();
        ArrayList<CommandParameter> buildTargetDescriptors = new ArrayList<CommandParameter>();
        ArrayList<CommandParameter> otherTargetDescriptors = new ArrayList<CommandParameter>();
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            ArrayList<CommandParameter> movedChildDescriptors = new ArrayList<CommandParameter>();
            CommandParameter select = null;
            CommandParameter query = null;
            CommandParameter intersect = null;
            for (Object descriptor : newChildDescriptors) {
                CommandParameter cmd = (CommandParameter)descriptor;
                if (cmd.feature != MetaABMActPackage.Literals.AACT__TARGETS) continue;
                movedChildDescriptors.add(cmd);
                if (cmd.getValue() instanceof AGroup) continue;
                if (cmd.getValue() instanceof ABuild || cmd.getValue() instanceof ACreateAgents || cmd.getValue() instanceof ABuildProjection) {
                    buildTargetDescriptors.add(cmd);
                    continue;
                }
                if (cmd.getValue() instanceof ACommand || cmd.getValue() instanceof AEvaluate) {
                    commandTargetDescriptors.add(cmd);
                    continue;
                }
                if (cmd.getValue() instanceof ASelect || cmd.getValue() instanceof AQuery || cmd.getValue() instanceof ALogic) {
                    selectTargetDescriptors.add(cmd);
                    if (cmd.getValue() instanceof ASelect) {
                        select = cmd;
                        continue;
                    }
                    if (cmd.getValue() instanceof AQuery) {
                        query = cmd;
                        continue;
                    }
                    if (!(cmd.getValue() instanceof AAll)) continue;
                    intersect = cmd;
                    continue;
                }
                otherTargetDescriptors.add(cmd);
            }
            newChildDescriptors.removeAll(movedChildDescriptors);
            if (select != null) {
                selectTargetDescriptors.remove(select);
                selectTargetDescriptors.add(0, select);
            }
            if (query != null) {
                selectTargetDescriptors.remove(query);
                selectTargetDescriptors.add(1, query);
            }
            if (intersect != null) {
                selectTargetDescriptors.remove(intersect);
                selectTargetDescriptors.add(2, intersect);
            }
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSelectTargetActions = this.generateCreateChildActions(selectTargetDescriptors, selection);
        this.createCommandTargetActions = this.generateCreateChildActions(commandTargetDescriptors, selection);
        this.createBuildTargetActions = this.generateCreateChildActions(buildTargetDescriptors, selection);
        this.createOtherTargetActions = this.generateCreateChildActions(otherTargetDescriptors, selection);
        this.populateAndUpdate(this.createChildMenuManager, this.createChildActions);
        this.populateAndUpdate((IMenuManager)this.createSelectTargetMenuManager, this.createSelectTargetActions);
        this.populateAndUpdate((IMenuManager)this.createCommandTargetMenuManager, this.createCommandTargetActions);
        this.populateAndUpdate((IMenuManager)this.createBuildTargetMenuManager, this.createBuildTargetActions);
        this.populateAndUpdate(this.createOtherTargetMenuManager, this.createOtherTargetActions);
    }

    private void populateAndUpdate(IMenuManager manager, Collection<IAction> memberActions) {
        manager.removeAll();
        if (manager != null && memberActions.size() > 0) {
            this.populateManager((IContributionManager)manager, memberActions, null);
            manager.update(true);
        }
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ISelection selection;
        Object sel = null;
        MetaABMEditor editor = (MetaABMEditor)this.getActiveEditor();
        if (editor != null && (selection = editor.getSelection()) instanceof StructuredSelection) {
            sel = ((StructuredSelection)selection).getFirstElement();
        }
        if ((this.style & 1) == 0) {
            menuManager.add((IContributionItem)new Separator("additions"));
        }
        menuManager.add((IContributionItem)new Separator("edit"));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.undoAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.redoAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.cutAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.copyAction));
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.pasteAction));
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IContributionItem)new ActionContributionItem((IAction)this.deleteAction));
        menuManager.add((IContributionItem)new Separator());
        if ((this.style & 1) != 0) {
            menuManager.add((IContributionItem)new Separator("additions"));
            menuManager.add((IContributionItem)new Separator());
        }
        menuManager.add((IContributionItem)new Separator("additions-end"));
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        if (this.getActiveEditor() != null && editor.getViewer() != null) {
            this.addItemsFor(menuManager, sel);
        }
        if (!(sel instanceof IID)) {
            this.addGlobalActions(menuManager);
        }
        this.prepareMenu(menuManager, this.createChildActions, "_UI_CreateChild_menu_item", "edit");
        MenuManager submenuManager = new MenuManager(MetaABMModelerPlugin.INSTANCE.getString("_UI_CreateTarget_menu"));
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("additions"));
        this.prepareMenu((IMenuManager)submenuManager, this.createSelectTargetActions, "_UI_CreateSelect_menu_item", "additions");
        this.prepareMenu((IMenuManager)submenuManager, this.createCommandTargetActions, "_UI_CreateCommand_menu_item", "additions");
        this.prepareMenu((IMenuManager)submenuManager, this.createBuildTargetActions, "_UI_CreateBuild_menu_item", "additions");
        this.prepareMenu((IMenuManager)submenuManager, this.createOtherTargetActions, "_UI_CreateOther_menu_item", "additions");
        this.prepareMenu(menuManager, this.otherActions, "_UI_Other_menu_item", "additions");
    }

    protected void addItemsFor(IMenuManager menuManager, Object sel) {
        if (sel instanceof SAgent) {
            menuManager.insertAfter("ui-actions", (IAction)((MetaABMEditor)this.activeEditor).getImportFromClassAction());
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)((MetaABMEditor)this.activeEditor).getImportFromClassAction());
        }
    }

    protected void prepareMenu(IMenuManager menuManager, Collection<? extends IAction> actions, String menuID, String seperator) {
        MenuManager submenuManager = new MenuManager(MetaABMModelerPlugin.INSTANCE.getString(menuID));
        this.populateManager((IContributionManager)submenuManager, actions, null);
        menuManager.insertBefore(seperator, (IContributionItem)submenuManager);
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        this.assignDefaultValuesAction.setEnabled(this.assignDefaultValuesAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.assignDefaultValuesAction);
        this.toggleStatsAction.setEnabled(this.toggleStatsAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.toggleStatsAction);
        super.addGlobalActions(menuManager);
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    public IMenuManager getSubmenuManager() {
        return this.submenuManager;
    }
}

