/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.ide.repast;

import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.metaabm.IID;
import org.metaabm.SAgent;
import org.metaabm.SAttribute;
import org.metaabm.SContinuousSpace;
import org.metaabm.SGeography;
import org.metaabm.SGrid;
import org.metaabm.SImplementation;
import org.metaabm.SNetwork;
import org.metaabm.SProjection;
import org.metaabm.xsd.MetaABMPersist;
import repast.score.SAttributeType;
import repast.score.SBorderRule;
import repast.score.SContext;
import repast.score.SImplementationMode;
import repast.score.SNamed;
import repast.score.ScoreFactory;
import repast.score.xsd.ContextPersist;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaABMScoreTransformer {
    ScoreFactory sf = ScoreFactory.eINSTANCE;
    private Map<String, String> genProperties;

    public MetaABMScoreTransformer(Map<String, String> genProperties) {
        this.genProperties = genProperties;
    }

    SContext create(org.metaabm.SContext m) {
        SContext s = this.sf.createSContext();
        this.transform((repast.score.SAgent)s, (SAgent)m);
        for (SAgent agent : m.getAgents()) {
            s.getAgents().add((Object)this.create(agent));
        }
        for (SAttribute attr : m.getAttributes()) {
            s.getAttributes().add((Object)this.create(attr));
        }
        for (SProjection proj : m.getProjections()) {
            if (proj instanceof SGrid) {
                s.getProjections().add((Object)this.create((SGrid)proj));
                continue;
            }
            if (proj instanceof SNetwork) {
                s.getProjections().add((Object)this.create((SNetwork)proj));
                continue;
            }
            if (proj instanceof SContinuousSpace) {
                s.getProjections().add((Object)this.create((SContinuousSpace)proj));
                continue;
            }
            if (proj instanceof SGeography) {
                s.getProjections().add((Object)this.create((SGeography)proj));
                continue;
            }
            throw new RuntimeException("Unhandled Projection type");
        }
        return s;
    }

    repast.score.SAgent create(SAgent m) {
        repast.score.SAgent s = this.sf.createSAgent();
        this.transform(s, m);
        for (SAttribute attr : m.getAttributes()) {
            s.getAttributes().add((Object)this.create(attr));
        }
        return s;
    }

    repast.score.SAttribute create(SAttribute m) {
        repast.score.SAttribute s = this.sf.createSAttribute();
        s.setDefaultValue(m.getDefaultValue());
        s.setGatherData(m.isGatherData());
        s.setSType(SAttributeType.getByName((String)m.getSType().getName()));
        if (s.getSType() == null) {
            s.setSType(SAttributeType.BOOLEAN_LITERAL);
        }
        s.setSType(SAttributeType.getByName((String)m.getSType().getName()));
        s.setUnits(m.getUnits());
        this.transform((repast.score.IID)s, (IID)m);
        return s;
    }

    repast.score.SProjection create(SProjection m) {
        return null;
    }

    repast.score.SProjection create(SGrid m) {
        repast.score.SGrid s = this.sf.createSGrid();
        s.setBorderRule(SBorderRule.getByName((String)m.getBorderRule().getName()));
        s.setDimensionality(m.getDimensionality());
        s.setMultiOccupant(m.isMultiOccupant());
        this.transform((SNamed)s, (org.metaabm.SNamed)m);
        return s;
    }

    repast.score.SProjection create(SContinuousSpace m) {
        repast.score.SContinuousSpace s = this.sf.createSContinuousSpace();
        s.setBorderRule(SBorderRule.getByName((String)m.getBorderRule().getName()));
        s.setDimensionality(m.getDimensionality());
        this.transform((SNamed)s, (org.metaabm.SNamed)m);
        return s;
    }

    repast.score.SProjection create(SNetwork m) {
        repast.score.SNetwork s = this.sf.createSNetwork();
        s.setDirected(m.isDirected());
        this.transform((SNamed)s, (org.metaabm.SNamed)m);
        return s;
    }

    repast.score.SProjection create(SGeography m) {
        repast.score.SGeography s = this.sf.createSGeography();
        this.transform((SNamed)s, (org.metaabm.SNamed)m);
        return s;
    }

    repast.score.SImplementation create(SImplementation m) {
        repast.score.SImplementation s = this.sf.createSImplementation();
        s.setBasePath("../" + this.getGenProperties().get("buildProject"));
        String binDir = m.getBinDir();
        if (binDir != null) {
            s.setBinDir(binDir);
        }
        s.setPackage(m.getPackage());
        s.setSrcDir(m.getSrcDir());
        s.setClassName(m.getClassName());
        s.setMode(SImplementationMode.GENERATE_LITERAL);
        return s;
    }

    void transform(repast.score.SAgent s, SAgent m) {
        s.setImplementation(this.create(m.getImplementation()));
        this.transform((SNamed)s, (org.metaabm.SNamed)m);
    }

    void transform(SNamed s, org.metaabm.SNamed m) {
        s.setDescription(m.getDescription());
        s.setPluralLabel(m.getPluralLabel());
        this.transform((repast.score.IID)s, (IID)m);
    }

    void transform(repast.score.IID s, IID m) {
        s.setLabel(m.getLabel());
        s.setID(m.getID());
    }

    public static String getScoreDirectory(IPath path) {
        return String.valueOf(path.removeLastSegments(1).toOSString()) + "/" + path.lastSegment().replace(".metaabm", ".rs");
    }

    public void generateScoreModel() {
        try {
            String modelPath = this.getGenProperties().get("modelPath");
            String outputPath = this.getGenProperties().get("outputPath");
            MetaABMPersist mLoader = MetaABMPersist.createURI((URI)URI.createPlatformResourceURI((String)modelPath, (boolean)false));
            mLoader.load();
            org.metaabm.SContext mContext = mLoader.getContext();
            SContext sContext = this.create(mContext);
            String scoreModelDir = String.valueOf(outputPath) + "/" + sContext.getImplementation().getClassName() + ".rs" + "/model.score";
            ContextPersist sSaver = ContextPersist.create((SContext)sContext, (String)scoreModelDir);
            sSaver.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, String> getGenProperties() {
        return this.genProperties;
    }
}

